#include <iostream>
#include <cstdio>
#include <fstream>
using namespace std;

const int N = (1 << 7);

string s_mov;

int mov[N];

int bit(int mask, int i)
{
    return (mask >> i) & 1;
}

int GetInt(int bit0, int bit1, int bit2, int bit3,
            int bit4, int bit5, int bit6)
{
    int result = 0;

    result += (1 << 0) * bit0;

    result += (1 << 1) * bit1;

    result += (1 << 2) * bit2;

    result += (1 << 3) * bit3;

    result += (1 << 4) * bit4;

    result += (1 << 5) * bit5;

    result += (1 << 6) * bit6;

    return result;
}

int GetNext(int mask_first, int mask_second)
{
    return GetInt(
                mov[GetInt(bit(mask_second, 0),
                           bit(mask_second, 1),
                           bit(mask_second, 11),
                           bit(mask_first, 0),
                           bit(mask_first, 1),
                           bit(mask_first, 2),
                           bit(mask_first, 3))],

                mov[GetInt(bit(mask_second, 1),
                           bit(mask_second, 2),
                           bit(mask_first, 0),
                           bit(mask_first, 1),
                           bit(mask_second, 3),
                           bit(mask_first, 3),
                           bit(mask_first, 4))],

                mov[GetInt(bit(mask_second, 11),
                           bit(mask_first, 0),
                           bit(mask_second, 10),
                           bit(mask_first, 2),
                           bit(mask_first, 3),
                           bit(mask_second, 9),
                           bit(mask_first, 5))],

                mov[mask_first],

                mov[GetInt(bit(mask_first, 1),
                           bit(mask_second, 3),
                           bit(mask_first, 3),
                           bit(mask_first, 4),
                           bit(mask_second, 4),
                           bit(mask_first, 6),
                           bit(mask_second, 5))],

                mov[GetInt(bit(mask_first, 2),
                           bit(mask_first, 3),
                           bit(mask_second, 9),
                           bit(mask_first, 5),
                           bit(mask_first, 6),
                           bit(mask_second, 8),
                           bit(mask_second, 7))],

                mov[GetInt(bit(mask_first, 3),
                           bit(mask_first, 4),
                           bit(mask_first, 5),
                           bit(mask_first, 6),
                           bit(mask_second, 5),
                           bit(mask_second, 7),
                           bit(mask_second, 6))]
            );
}

void ShowMask(int mask)
{
    for (int i = 0; i < 7; ++i) {
        cout << bit(mask, i);
    }
    cout << endl;
}

int main() {
  //  freopen("input.txt", "r", stdin);

    ios_base::sync_with_stdio(false);

    while (true) {
        cin >> s_mov;

        if (s_mov.length() == 1) {
            break;
        }

        for (int i = 0; i < N; ++i) {
            mov[i] = s_mov[i] - '0';
        }

        bool is_idemp = true;

        for (int mask_first = 0; mask_first < (1 << 7); ++mask_first) {
            for (int mask_second = 0; mask_second < (1 << 12); ++mask_second) {
                int new_mask_first = GetNext(mask_first, mask_second);

                int b = mov[new_mask_first];

                if (b != bit(new_mask_first, 3)) {
                    is_idemp = false;
                }
            }
        }

        if (is_idemp) {
            cout << "yes" << endl;
        } else {
            cout << "no" << endl;
        }
    }

    return 0;
}
